---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-リカレント層（Recurrent Layers）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **backend.rnnの内部ループ実装詳細**：根拠不足
  2. **cuDNN自動選択の条件詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）
- E-01: `tensorflow/python/keras/layers/recurrent.py` 行55-193（StackedRNNCells）
- E-02: `tensorflow/python/keras/layers/recurrent.py` 行196-599（RNN基底クラス）
- E-03: `tensorflow/core/ops/rnn_ops.cc` 行25-100（GRUBlockCell, LSTMBlockCell Op登録）
- E-04: `tensorflow/core/ops/cudnn_rnn_ops.cc` 行24-111（cuDNN RNN Op登録）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 行22（機能一覧エントリ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LSTM・GRU・SimpleRNNを提供 | E-02, E-05 | ○ |
| C-02 | cellにcallとstate_sizeが必須 | E-02 (行399-406) | ○ |
| C-03 | リストの場合StackedRNNCellsでラップ | E-02 (行397-398) | ○ |
| C-04 | return_sequences/return_state制御 | E-02 (行239-296) | ○ |
| C-05 | stateful=Trueで状態保持 | E-02 (行304-320) | ○ |
| C-06 | statefulはStrategy非対応 | E-02 (行437-439) | ○ |
| C-07 | unroll=Trueは固定長のみ | E-02 (行250-252) | ○ |
| C-08 | time_majorによる入力形式切替 | E-02 (行253-260) | ○ |
| C-09 | マスキング対応 | E-02 (行298-302, 426) | ○ |
| C-10 | GRUBlockCellの入出力定義 | E-03 (行25-49) | ○ |
| C-11 | LSTMBlockCellの入出力定義 | E-03 (行85-100) | ○ |
| C-12 | StackedRNNCellsのcall処理 | E-01 (行129-157) | ○ |
| C-13 | reverse_state_orderの後方互換 | E-01 (行94-99) | ○ |
| C-14 | compute_output_shapeの動作 | E-02 (行465-516) | ○ |
| C-15 | cuDNN対応セルで最適化カーネル自動選択 | E-04 | ○ |
| C-16 | recurrent_dropoutはimpl=2と非互換 | E-02 (行50-52) | ○ |
| C-17 | backend.rnnでタイムステップループ実行 | **根拠不足** | △ |
| C-18 | cuDNN自動選択の具体的条件 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- backend.rnnの内部ループ実装はbackend.pyにあるが、本分析では直接読み取っていない
  - 候補：`tensorflow/python/keras/backend.py` のrnn関数
- cuDNN自動選択条件の詳細はcudnn_rnn_layers.pyに記載されている可能性がある
  - 候補：`tensorflow/python/keras/layers/cudnn_recurrent.py`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能説明はソースコードと整合している
- 1: 中リスク - backend.rnnの内部実装詳細は追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] StackedRNNCellsのcall処理フローが実コードと一致しているか
- [ ] stateful制約の記述が最新バージョンと合致しているか
- [ ] cuDNN自動選択条件の補完が必要か確認
